%This program is used to compute the ATS for AR(1) cases when the IC mean function, variance
%function and phi are known.
%k is the reference value
%limit is the cntrol limit
%N it the number of replications
%phi is the coefficient of AR(1) model
%m out of n is the sampling rate
%delta is the shift size
%L is the total number of time points
function [avats,anos,C,l]=AVATS_Dtime(k,limit,N,phi,m,n,delta,L)
l=1;
ats=zeros(1,N);
ANOS=zeros(1,N);
C=1;
% xx=delta*ones(1,L);
xx=delta*(1-exp(-10*[1:L]./L));
while (l<=N)
 [temp1,temp2]=ATS_Dtime(zeros(1,L),ones(1,L),xx,ones(1,L),k,limit,phi,m,n);
 C=C+1;
 if temp1<L
   ats(1,l)=temp1;
   ANOS(1,l)=temp2;
   l=l+1;
 end
end
avats=mean(ats);
anos=mean(ANOS);